package com.biz.crm.sfa.worksignrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.sfa.worksignrule.SfaWorkSignExecuteFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author ren.gang
 * @ClassName SfaWorkSignExecuteFeignImpl.java
 * @Description TODO
 * @createTime 2020年12月31日 14:44:00
 */
@Slf4j
@Component
public class SfaWorkSignExecuteFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignExecuteFeign> {
    @Override
    public SfaWorkSignExecuteFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignExecuteFeign() {
            @Override
            public Result executeWorkSignRule(SfaWorkSignExecuteReqVo reqVo) {
                return doBack();
            }
        };
    }
}
