package com.biz.crm.sfa.worksignrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.sfa.worksignrule.SfaWorkSignPersonnelFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤规则-打卡人员 feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-16 15:06:20
 */
@Slf4j
@Component
public class SfaWorkSignPersonnelFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignPersonnelFeign> {

    @Override
    public SfaWorkSignPersonnelFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignPersonnelFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignPersonnelRespVo>> list(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                doBack();
                PageResult<SfaWorkSignPersonnelRespVo> build = PageResult.<SfaWorkSignPersonnelRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignPersonnelRespVo> query(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignPersonnelReqVo sfaWorkSignPersonnelReqVo) {
                return doBack();
            }
        };
    }
}
