package com.biz.crm.sfa.worksignrule.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignExecuteReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.SfaWorkSignRuleVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.sfa.worksignrule.SfaWorkSignRuleFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 考勤规则;考勤规则feign接口熔断类
 *
 * @author liuhongming
 * @date 2020-09-16 14:50:03
 */
@Slf4j
@Component
public class SfaWorkSignRuleFeignImpl extends BaseAbstract implements FallbackFactory<SfaWorkSignRuleFeign> {

    @Override
    public SfaWorkSignRuleFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SfaWorkSignRuleFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<SfaWorkSignRuleRespVo>> list(SfaWorkSignRuleVo sfaWorkSignRuleVo) {
                doBack();
                PageResult<SfaWorkSignRuleRespVo> build = PageResult.<SfaWorkSignRuleRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<SfaWorkSignRuleRespVo> query(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo) {
                return doBack();
            }

        };
    }
}
