package com.biz.crm.tpm.account;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.tpm.account.impl.TpmAccountDetailFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 费用上账表;feign接口
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAccountDetailFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAccountDetailFeignImpl.class)
public interface TpmAccountDetailFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmaccountdetail/list")
    Result<PageResult<TpmAccountDetailRespVo>> list(@RequestBody TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmaccountdetail/queryView")
    Result<TpmAccountDetailMainRespVo> queryView(@RequestBody TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmaccountdetail/save")
    Result save(@RequestBody TpmAccountDetailMainReqVo accountDetailMainReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmaccountdetail/update")
    Result update(@RequestBody TpmAccountDetailMainReqVo accountDetailMainReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmaccountdetail/delete")
    Result delete(@RequestBody TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmaccountdetail/enable")
    Result enable(@RequestBody TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmaccountdetail/disable")
    Result disable(@RequestBody  TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 批量修改支付方式
     * @param accountUpdatePayTypeReqVo
     * @return
     */
    @PostMapping("/tpmaccountdetail/batchUpdatePayType")
    Result batchUpdatePayType(TpmAccountUpdatePayTypeReqVo accountUpdatePayTypeReqVo);
}
