package com.biz.crm.tpm.account;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountProductReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountProductRespVo;
import com.biz.crm.tpm.account.impl.TpmAccountProductFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 费用上账货补产品表 feign接口
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAccountProductFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAccountProductFeignImpl.class)
public interface TpmAccountProductFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmaccountproduct/list")
    Result<PageResult<TpmAccountProductRespVo>> list(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmaccountproduct/query")
    Result<TpmAccountProductRespVo> query(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmaccountproduct/save")
    Result save(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmaccountproduct/update")
    Result update(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmaccountproduct/delete")
    Result delete(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmaccountproduct/enable")
    Result enable(@RequestBody TpmAccountProductReqVo tpmAccountProductReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmaccountproduct/disable")
    Result disable(@RequestBody  TpmAccountProductReqVo tpmAccountProductReqVo);
}
