package com.biz.crm.tpm.account.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.tpm.account.TpmAccountInvoiceFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 费用上账发票关联表;feign接口熔断类
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@Component
public class TpmAccountInvoiceFeignImpl extends BaseAbstract implements FallbackFactory<TpmAccountInvoiceFeign> {

    @Override
    public TpmAccountInvoiceFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAccountInvoiceFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAccountInvoiceRespVo>> list(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                doBack();
                PageResult<TpmAccountInvoiceRespVo> build = PageResult.<TpmAccountInvoiceRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAccountInvoiceRespVo> query(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo) {
                return doBack();
            }
        };
    }
}
