package com.biz.crm.tpm.act;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.act.impl.TpmActBudgetFeignImpl;

/**
 * 活动预算信息表;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActBudgetFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActBudgetFeignImpl.class)
public interface TpmActBudgetFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmactbudget/list")
    Result<PageResult<TpmActBudgetRespVo>> list(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmactbudget/query")
    Result<TpmActBudgetRespVo> query(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmactbudget/save")
    Result save(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmactbudget/update")
    Result update(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmactbudget/delete")
    Result delete(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmactbudget/enable")
    Result enable(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmactbudget/disable")
    Result disable(@RequestBody TpmActBudgetReqVo tpmActBudgetReqVo);
}
