package com.biz.crm.tpm.act;

import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.act.impl.TpmActFeignImpl;

import java.util.List;

/**
 * 活动信息主表;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActFeignImpl.class)
public interface TpmActFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmActController/list")
    Result<PageResult<TpmActRespVo>> list(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 查询
     */
    @GetMapping("/tpmActController/query")
    Result<TpmActRespVo> query(@RequestParam(value = "id") String id);

    /**
     * 新增
     */
    @PostMapping("/tpmActController/save")
    Result save(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmActController/update")
    Result update(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmActController/delete")
    Result delete(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmActController/enable")
    Result enable(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmActController/disable")
    Result disable(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 提交审批
     */
    @PostMapping("/tpmActController/approve")
    Result approve(@RequestBody TpmActReqVo tpmActReqVo);

    /**
     * 活动新增根据选定的费用预算维度查询活动大类
     */
    @PostMapping("/tpmActController/getCategoriesByBudget")
    Result<List<TpmCostTypeCategoriesRespVo>> getCategoriesByBudget(@RequestBody ActGetCategoriesByBudgetReqVo reqVo);

    /**
     * 跟据活动大类查出活动细类集合
     * @param tpmActDetailReqVo
     * @return
     */
    @PostMapping("/tpmActController/getCategoryFinesByCategoryCode")
    Result<List<TpmCostTypeFineRespVo>> getCategoryFinesByCategoryCode(@RequestBody TpmActDetailReqVo tpmActDetailReqVo);
}
