package com.biz.crm.tpm.act.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.act.TmpActFeeShareFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 活动费用分摊表;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TmpActFeeShareFeignImpl extends BaseAbstract implements FallbackFactory<TmpActFeeShareFeign> {

    @Override
    public TmpActFeeShareFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TmpActFeeShareFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TmpActFeeShareRespVo>> list(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                doBack();
                PageResult<TmpActFeeShareRespVo> build = PageResult.<TmpActFeeShareRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TmpActFeeShareRespVo> query(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TmpActFeeShareReqVo tmpActFeeShareReqVo) {
                return doBack();
            }
        };
    }
}
