package com.biz.crm.tpm.act.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.act.TpmActFileFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 活动附件信息;feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Component
public class TpmActFileFeignImpl extends BaseAbstract implements FallbackFactory<TpmActFileFeign> {

    @Override
    public TpmActFileFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmActFileFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmActFileRespVo>> list(TpmActFileReqVo tpmActFileReqVo) {
                doBack();
                PageResult<TpmActFileRespVo> build = PageResult.<TpmActFileRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmActFileRespVo> query(TpmActFileReqVo tpmActFileReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmActFileReqVo tpmActFileReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmActFileReqVo tpmActFileReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmActFileReqVo tpmActFileReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmActFileReqVo tpmActFileReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmActFileReqVo tpmActFileReqVo) {
                return doBack();
            }
        };
    }
}
