package com.biz.crm.tpm.actfieldcollect;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;
import com.biz.crm.tpm.actfieldcollect.impl.TpmActCollectFieldFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 活动采集字段表;feign接口
 *
 * @author zeyi
 * @date 2020-11-03 13:42:29
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "TpmActCollectFieldFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmActCollectFieldFeignImpl.class)
public interface TpmActCollectFieldFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmactcollectfield/list")
    Result<PageResult<TpmActCollectFieldRespVo>> list(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmactcollectfield/query")
    Result<TpmActCollectFieldRespVo> query(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmactcollectfield/save")
    Result save(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmactcollectfield/update")
    Result update(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmactcollectfield/delete")
    Result delete(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmactcollectfield/enable")
    Result enable(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmactcollectfield/disable")
    Result disable(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo);
}
