package com.biz.crm.tpm.advancepay;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.tpm.act.impl.TpmActCallBackFeignImpl;
import com.biz.crm.tpm.advancepay.impl.TpmAdvanceCallBackFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 预付审批回调;feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmAdvanceCallBackFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmAdvanceCallBackFeignImpl.class)
public interface TpmAdvanceCallBackFeign extends CallbackFeign {

    /**
     * 回调方法
     * @param activitiCallBackVo
     * @return
     */
    @Override
    @PostMapping("/tpmActAdvancePayController/activityCallBack")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}
