package com.biz.crm.tpm.audit.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;
import com.biz.crm.tpm.audit.TpmAuditFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 核销申请主表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Component
public class TpmAuditFeignImpl extends BaseAbstract implements FallbackFactory<TpmAuditFeign> {

    @Override
    public TpmAuditFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmAuditFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmAuditRespVo>> list(TpmAuditReqVo tpmAuditReqVo) {
                doBack();
                PageResult<TpmAuditRespVo> build = PageResult.<TpmAuditRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmAuditRespVo> query(TpmAuditReqVo tpmAuditReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmAuditReqVo tpmAuditReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmAuditReqVo tpmAuditReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmAuditReqVo tpmAuditReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmAuditReqVo tpmAuditReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmAuditReqVo tpmAuditReqVo) {
                return doBack();
            }

            /**
             * 核销申请新增的活动明细列表
             * @param reqVo
             * @return
             */
            @Override
            public Result<PageResult<TpmActDetailRespVo>> actDetailList(TpmActDetailReqVo reqVo) {
                doBack();
                PageResult<TpmActDetailRespVo> build = PageResult.<TpmActDetailRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            @Override
            public Result<PageResult<TpmActRespVo>> actList(TpmActReqVo tpmActReqVo) {
                doBack();
                PageResult<TpmActRespVo> build = PageResult.<TpmActRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 核销审批
             * @param reqVo
             * @return
             */
            @Override
            public Result auditApproved(TpmAuditReqVo reqVo) {
                return doBack();
            }
        };
    }
}
