package com.biz.crm.tpm.costtypecategories;

import com.biz.crm.nebular.tpm.act.req.ActGetCategoriesByBudgetReqVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.tpm.costtypecategories.impl.TpmCostTypeCategoriesFeignImpl;

import java.util.List;

/**
 * 活动大类 feign接口
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "tpmcosttypecategoriesFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmCostTypeCategoriesFeignImpl.class)
public interface TpmCostTypeCategoriesFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmcosttypecategories/list")
    Result<PageResult<TpmCostTypeCategoriesRespVo>> list(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmcosttypecategories/query")
    Result<TpmCostTypeCategoriesRespVo> query(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmcosttypecategories/save")
    Result save(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmcosttypecategories/update")
    Result update(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmcosttypecategories/delete")
    Result delete(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmcosttypecategories/enable")
    Result enable(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmcosttypecategories/disable")
    Result disable(@RequestBody TpmCostTypeCategoriesReqVo tpmCostTypeCategoriesReqVo);

}
