package com.biz.crm.tpm.feebudget;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.feebudget.impl.TpmFeeBudgetControlFeignImpl;

/**
 * 费用预算管控维度表 feign接口
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmFeeBudgetControlFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmFeeBudgetControlFeignImpl.class)
public interface TpmFeeBudgetControlFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmfeebudgetcontrol/list")
    Result<PageResult<TpmFeeBudgetControlRespVo>> list(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmfeebudgetcontrol/query")
    Result<TpmFeeBudgetControlRespVo> query(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmfeebudgetcontrol/save")
    Result save(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmfeebudgetcontrol/update")
    Result update(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmfeebudgetcontrol/delete")
    Result delete(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmfeebudgetcontrol/enable")
    Result enable(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmfeebudgetcontrol/disable")
    Result disable(@RequestBody TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo);
}
