package com.biz.crm.tpm.feebudget;

import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import com.biz.crm.tpm.feebudget.impl.TpmFeeBudgetFeignImpl;

/**
 * 费用预算 feign接口
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmFeeBudgetFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmFeeBudgetFeignImpl.class)
public interface TpmFeeBudgetFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmfeebudget/list")
    Result<PageResult<TpmFeeBudgetRespVo>> list(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmfeebudget/query")
    Result<TpmFeeBudgetRespVo> query(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmfeebudget/save")
    Result save(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmfeebudget/update")
    Result update(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmfeebudget/delete")
    Result delete(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmfeebudget/enable")
    Result enable(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmfeebudget/disable")
    Result disable(@RequestBody TpmFeeBudgetReqVo tpmFeeBudgetReqVo);

    /**
     * 变更
     * @param tpmFeeBudgetReqVo
     * @return
     */
    @ApiOperation(value = "变更")
    @PostMapping("/tpmfeebudget/change")
    Result change(@RequestBody  TpmFeeBudgetReqVo tpmFeeBudgetReqVo);
    /**
     * 调整
     * @param tpmFeeBudgetReqVo
     * @return
     */
    @ApiOperation(value = "调整")
    @PostMapping("/tpmfeebudget/adjust")
    Result adjust(@RequestBody  TpmFeeBudgetReqVo tpmFeeBudgetReqVo);
}
