package com.biz.crm.tpm.feebudget.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.feebudget.TpmFeeBudgetControlFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 费用预算管控维度表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-23 18:52:12
 */
@Slf4j
@Component
public class TpmFeeBudgetControlFeignImpl extends BaseAbstract implements FallbackFactory<TpmFeeBudgetControlFeign> {

    @Override
    public TpmFeeBudgetControlFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmFeeBudgetControlFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmFeeBudgetControlRespVo>> list(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                doBack();
                PageResult<TpmFeeBudgetControlRespVo> build = PageResult.<TpmFeeBudgetControlRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmFeeBudgetControlRespVo> query(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmFeeBudgetControlReqVo tpmFeeBudgetControlReqVo) {
                return doBack();
            }
        };
    }
}
