package com.biz.crm.tpm.feebudget.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.tpm.feebudget.TpmFeeBudgetFeign;
import feign.hystrix.FallbackFactory;

import java.util.ArrayList;

/**
 * 费用预算 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-09-14 17:11:59
 */
@Slf4j
@Component
public class TpmFeeBudgetFeignImpl extends BaseAbstract implements FallbackFactory<TpmFeeBudgetFeign> {

    @Override
    public TpmFeeBudgetFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TpmFeeBudgetFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TpmFeeBudgetRespVo>> list(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                doBack();
                PageResult<TpmFeeBudgetRespVo> build = PageResult.<TpmFeeBudgetRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TpmFeeBudgetRespVo> query(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            @Override
            public Result change(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            @Override
            public Result adjust(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TpmFeeBudgetReqVo tpmFeeBudgetReqVo) {
                return doBack();
            }
        };
    }
}
