package com.biz.crm.tpm.scales;

import com.biz.crm.nebular.tpm.sale.req.TpmSalesDataReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesDataRespVo;
import com.biz.crm.tpm.scales.impl.TpmSalesDataFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

/**
 * 实际销售数据 feign接口
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmSalesDataFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmSalesDataFeignImpl.class)
public interface TpmSalesDataFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmsalesdata/list")
    Result<PageResult<TpmSalesDataRespVo>> list(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmsalesdata/query")
    Result<TpmSalesDataRespVo> query(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmsalesdata/save")
    Result save(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmsalesdata/update")
    Result update(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmsalesdata/delete")
    Result delete(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmsalesdata/enable")
    Result enable(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmsalesdata/disable")
    Result disable(@RequestBody TpmSalesDataReqVo tpmSalesDataReqVo);
}
