package com.biz.crm.tpm.scales;

import com.biz.crm.nebular.tpm.sale.req.TpmSalesPlansReqVo;
import com.biz.crm.nebular.tpm.sale.resp.TpmSalesPlansRespVo;
import com.biz.crm.tpm.scales.impl.TpmSalesPlansFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

/**
 * 销售计划 feign接口
 *
 * @author jerry7
 * @date 2021-04-28 15:32:39
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TpmSalesPlansFeign",name="crm-tpm",path = "tpm",fallbackFactory = TpmSalesPlansFeignImpl.class)
public interface TpmSalesPlansFeign {

    /**
     * 列表
     */
    @PostMapping("/tpmsalesplans/list")
    Result<PageResult<TpmSalesPlansRespVo>> list(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 查询
     */
    @PostMapping("/tpmsalesplans/query")
    Result<TpmSalesPlansRespVo> query(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 新增
     */
    @PostMapping("/tpmsalesplans/save")
    Result save(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 更新
     */
    @PostMapping("/tpmsalesplans/update")
    Result update(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 删除
     */
    @PostMapping("/tpmsalesplans/delete")
    Result delete(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 启用
     */
    @PostMapping("/tpmsalesplans/enable")
    Result enable(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);

    /**
     * 禁用
     */
    @PostMapping("/tpmsalesplans/disable")
    Result disable(@RequestBody TpmSalesPlansReqVo tpmSalesPlansReqVo);
}
