package com.biz.crm.upload.file;

import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.nebular.upload.vo.WordTemplateDataVo;
import com.biz.crm.upload.file.impl.OfficeFileFeignImpl;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Description Office文件处理
 * @Author Gavin
 * @Date Created in 2021/3/20 下午12:29
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "OfficeFileFeign", name = "crm-upload", path = "upload", fallbackFactory = OfficeFileFeignImpl.class)
public interface OfficeFileFeign {

    @PostMapping("/officeFileController/createWordToPdfFile")
    Result<List<UploadVo>> createWordDocxToPdfFile(@RequestBody WordTemplateDataVo dataVo);
}