package com.biz.crm.upload.file.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.nebular.upload.vo.WordTemplateDataVo;
import com.biz.crm.upload.file.OfficeFileFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.upload.file.impl
 * @ClassName OfficeFileFeignImpl
 * @Author Gavin
 * @Date 2021/3/20 下午1:14
 * @Description office文件处理实现
 */
@Slf4j
@Component
public class OfficeFileFeignImpl extends BaseAbstract implements FallbackFactory<OfficeFileFeign> {
    @Override
    public OfficeFileFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new OfficeFileFeign() {
            @Override
            public Result<List<UploadVo>> createWordDocxToPdfFile(WordTemplateDataVo dataVo) {
                return doBack();
            }
        };
    }
}