package com.biz.crm.webservice.mail.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.nebular.webservice.mail.CrmMailMessage;
import com.biz.crm.util.Result;
import com.biz.crm.webservice.mail.MailFeign;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class MailFeignImpl extends BaseAbstract implements FallbackFactory<MailFeign> {

    @Override
    public MailFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MailFeign() {

            @Override
            public Result sendMail(CrmMailMessage crmMailMessage) {
                return doBack();
            }

        };
    }
}
