package com.biz.crm.webservice.message.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.util.Result;
import com.biz.crm.webservice.message.ShortMessageFeign;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class ShortMessageFeignImpl extends BaseAbstract implements FallbackFactory<ShortMessageFeign> {

    @Override
    public ShortMessageFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new ShortMessageFeign() {

            @Override
            public Result<Boolean> sendMessage(ShortMessage shortMessage) {
                return doBack();
            }
        };
    }
}
