package com.biz.crm.activiti.act.impl;

import com.biz.crm.activiti.act.TaAgencyApprovalFeign;
import com.biz.crm.nebular.activiti.act.req.TaAgencyApprovalReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaAgencyApprovalRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2021-01-11 16:39:03
 */
@Slf4j
@Component
public class TaAgencyApprovalFeignImpl extends BaseAbstract implements FallbackFactory<TaAgencyApprovalFeign> {

    @Override
    public TaAgencyApprovalFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TaAgencyApprovalFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TaAgencyApprovalRespVo>> list(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                doBack();
                PageResult<TaAgencyApprovalRespVo> build = PageResult.<TaAgencyApprovalRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaAgencyApprovalRespVo> query(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(TaAgencyApprovalReqVo taAgencyApprovalReqVo) {
                return doBack();
            }
        };
    }
}
