package com.biz.crm.activiti.listener;

import com.biz.crm.activiti.listener.impl.TaListenerFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import java.util.List;

/**
 * feign接口
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "TaListenerFeign",name="crm-activiti",path = "activiti",fallbackFactory = TaListenerFeignImpl.class)
public interface TaListenerFeign {

    /**
     * 列表
     */
    @PostMapping("/talistener/list")
    Result<PageResult<TaListenerRespVo>> list(@RequestBody TaListenerReqVo taListenerReqVo);

    /**
     * 查询
     */
    @GetMapping("/talistener/query")
    Result<TaListenerRespVo> query(@RequestParam(value = "id",required = false)String id);

    /**
     * 新增
     */
    @PostMapping("/talistener/save")
    Result save(@RequestBody TaListenerReqVo taListenerReqVo);

    /**
     * 更新
     */
    @PostMapping("/talistener/update")
    Result update(@RequestBody TaListenerReqVo taListenerReqVo);

    /**
     * 删除
     */
    @PostMapping("/talistener/delete")
    Result delete(@RequestBody List<String> ids);

    /**
     * 启用
     */
    @PostMapping("/talistener/enable")
    Result enable(@RequestBody List<String> ids);

    /**
     * 禁用
     */
    @PostMapping("/talistener/disable")
    Result disable(@RequestBody List<String> ids);
}
