package com.biz.crm.activiti.listener.impl;

import com.biz.crm.activiti.listener.TaListenerProcFeign;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Slf4j
@Component
public class TaListenerProcFeignImpl extends BaseAbstract implements FallbackFactory<TaListenerProcFeign> {

    @Override
    public TaListenerProcFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TaListenerProcFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<TaListenerProcRespVo>> list(TaListenerProcReqVo taListenerProcReqVo) {
                doBack();
                PageResult<TaListenerProcRespVo> build = PageResult.<TaListenerProcRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<TaListenerProcRespVo> query(String id) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(TaListenerProcReqVo taListenerProcReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(TaListenerProcReqVo taListenerProcReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(List<String> ids) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(List<String> ids) {
                return doBack();
            }
        };
    }
}
