package com.biz.crm.activiti.mobile.impl;

import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.*;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName ActivitiMobileFeignImpl.java
 * @Description 工作流移动端熔断
 * @createTime 2020年11月26日 11:08:00
 */
@Slf4j
@Component
public class ActivitiMobileFeignImpl extends BaseAbstract implements FallbackFactory<ActivitiMobileFeign> {
    @Override
    public ActivitiMobileFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new ActivitiMobileFeign() {
            @Override
            public Result taskComplete(TaskOptReqVO taskOptReqVO) {
                return doBack();
            }

            @Override
            public Result taskReject(TaskOptReqVO taskOptReqVO) {
                return doBack();
            }

            @Override
            public Result cancelProcess(CancelProcessReqVO cancelProcessReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<TaskRspVO>> findCurrentTask(TaskQueryReqVO taskReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<TaskRspVO>> findDoneTask(TaskQueryReqVO taskReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<TaskRspVO>> findStartTask(TaskQueryReqVO taskReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<OptRecordRspVO>> getOptRecords(OptRecordReqVO optRecordReqVO) {
                return doBack();
            }

            @Override
            public Result<ProcessInfoRspVO> getProcessInfo(ProcessInfoReqVO processInfoReqVO) {
                return doBack();
            }

            @Override
            public Result<List<OptLogsRspVO>> getOptLogs(OptRecordReqVO optRecordReqVO) {
                return doBack();
            }

            @Override
            public Result<PageResult<CopyTaskRspVO>> findMyCopyTask(CopyTaskReqVO copyTaskReqVO) {
                return doBack();
            }

            @Override
            public Result readCopyTask(ReadCopyTaskReqVO readCopyTaskReqVO) {
                return doBack();
            }
        };
    }
}
