package com.biz.crm.base;

import com.biz.crm.common.CrmFeignException;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;

/**
 * @Author: clare
 * @Description: 返回参数判断共用方法
 * @Date: 19:18 2019/4/24
 */
public class ApiResultUtil {

    //检查返回值--ajax
    public static boolean checkResult(Result json){
        if(json != null){
            return json.isSuccess();
        }
        return false;
    }

    //返回对象集合信息
    public static <T> T objResult(Result<T> json){
        return objResult(json,false);
    }

    /**
     *
     * @param json
     * @param notNull true 返回success必须为true 否则报异常
     * @param <T>
     * @return
     */
    public static <T> T objResult(Result<T> json,boolean notNull){
        if(checkResult(json)){
            return json.getResult();
        }
        if(notNull){
            if(StringUtils.isEmpty(json.getMessage())){
                throw new RuntimeException(json.getMessage());
            }else {
                throw new CrmFeignException(json.getMessage());
            }
        }
        return json.getResult();
    }
}
