package com.biz.crm.dms.companyinformation;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.companyinformation.impl.CompanyInformationFeignImpl;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;

/** 公司资料
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/09/27 15:34
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "companyInformationFeign",name="crm-dms",path = "dms",fallbackFactory = CompanyInformationFeignImpl.class)
public interface CompanyInformationFeign {

    /**
     * 新增
     */
    @PostMapping(value = "/m/companyInformation/add")
    Result add(@RequestBody CompanyInformationVo companyInformationVo);

    /**
     * 编辑
     */
    @PostMapping(value = "/m/companyInformation/edit")
    Result edit(@RequestBody CompanyInformationVo companyInformationVo);

    /**
     * 通过id查询
     */
    @GetMapping(value = "/m/companyInformation/findById/{id}")
    Result<CompanyInformationVo> findById(@PathVariable("id") String id);

    /**
     * 分页搜索公司资料
     */
    @PostMapping(value = "/m/companyInformation/list")
    Result<PageResult<CompanyInformationVo>> list(@RequestBody CompanyInformationVo companyInformationVo);

    /**
     * 根据id批量删除
     */
    @PostMapping(value = "/m/companyInformation/delByIds")
    Result<Object> delByIds(@RequestBody ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     */
    @PostMapping(value = "/m/companyInformation/delByParam")
    Result<Object> delByParam(@RequestBody CompanyInformationVo companyInformationVo);

}
