package com.biz.crm.dms.promotion.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.PromotionFeign;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeSourceVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-19 18:15
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class PromotionFeignImpl extends BaseAbstract implements FallbackFactory<PromotionFeign> {
    @Override
    public PromotionFeign create(Throwable throwable) {
        log.error("促销政策PromotionFeign进入熔断",throwable);
        return new PromotionFeign() {

            @Override
            public Result<PageResult<PromotionInfoRespVo>> findPromotionsByParamV2(PromotionPolicyQueryVo reqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<PromotionInfoRespVo>> findPromotionsByParam(PromotionPolicyQueryVo reqVo) {
                return doBack();
            }

            /**
             * 创建促销政策
             * @param promotionEditVo
             * @return
             */
            @Override
            public Result<PromotionEditVo> create(PromotionEditVo promotionEditVo) {
                return doBack();
            }

            /**
             * 更新促销政策
             * @param promotionEditVo
             * @return
             */
            @Override
            public Result<PromotionEditVo> update(PromotionEditVo promotionEditVo) {
                return doBack();
            }

            /**
             * 根据id查询详情
             * @param id
             * @return
             */
            @Override
            public Result<PromotionEditVo> findDetailsById(String id) {
                return doBack();
            }

            /**
             * 分页查询促销范围数据源
             * @param param
             * @return
             */
            @Override
            public Result<PageResult<PromotionScopeSourceVo>> findScopeSourcePage(PromotionScopeSourceVo param) {
                return doBack();
            }

            @Override
            public Result<PageResult<PromotionEditVo>> findPromotionPageByConditionsV2(PromotionEditVo param) {
                return doBack();
            }

            /**
             * 分页查询促销政策
             * @param param
             * @return
             */
            @Override
            public Result<PageResult<PromotionEditVo>> findPromotionPageByConditions(PromotionEditVo param) {
                return doBack();
            }

            /**
             * 根据客户以及商品（本品）查询可用的所有促销政策
             * @param param
             * @return
             */
            @Override
            public Result<List<PromotionAvailableResp>> findAvailablePromotionsByAccount(PromotionQueryReq param) {
                return doBack();
            }

            /**
             * 根据促销政策编码列表查询促销政策命中情况
             * @param param
             * @return
             */
            @Override
            public Result<List<PromotionEditVo>> findHitPromotionsByPromotionCodes(PromotionQueryReq param) {
                return doBack();
            }

            /**
             * 根据促销政策编码列表查询促销政策命中情况
             * @param params
             * @return
             */
            @Override
            public Result<Map<String, PromotionEditVo>> findHitPromotionMapByPromotionCodes(ArrayList<PromotionQueryReq> params) {
                return doBack();
            }

            /**
             * 根据客户查询是否有可用政策
             * @param param
             * @return
             */
            @Override
            public Result<Map<String, Boolean>> findAvailablePromotionMapByCus(PromotionQueryReq param) {
                return doBack();
            }

            /**
             * 审批流回调方法
             * @param activitiCallBackVo
             * @return
             */
            @Override
            public Result callback(ActivitiCallBackVo activitiCallBackVo) {
                return doBack();
            }
        };
    }
}
