package com.biz.crm.job.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.job.QrtzScheduleJobFeign;
import com.biz.crm.nebular.job.req.QrtzScheduleJobReqVo;
import com.biz.crm.nebular.job.resp.QrtzScheduleJobRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @Project crm-core-prd
 * @PackageName com.biz.crm.job.impl
 * @ClassName QrtzScheduleJobFeignImpl
 * @Author X.S
 * @Date 2020/9/30 5:04 PM
 * @Description
 */
@Slf4j
@Component
public class QrtzScheduleJobFeignImpl extends BaseAbstract implements FallbackFactory<QrtzScheduleJobFeign> {

    @Override
    public QrtzScheduleJobFeign create(Throwable throwable) {
        return new QrtzScheduleJobFeign() {
            @Override
            public Result<PageResult<QrtzScheduleJobRespVo>> list(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                doBack();
                PageResult<QrtzScheduleJobRespVo> build = PageResult.<QrtzScheduleJobRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            @Override
            public Result<QrtzScheduleJobRespVo> query(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            @Override
            public Result save(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            @Override
            public Result update(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            @Override
            public Result enable(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            @Override
            public Result disable(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            @Override
            public Result delete(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }

            @Override
            public Result runOnce(QrtzScheduleJobReqVo sfaVisitPlanReqVo) {
                return doBack();
            }
        };
    }
}
