package com.biz.crm.mdm.availablelist.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelist.AvailableListFeign;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/13 13:50
 **/
@Slf4j
@Component
public class AvailableListFeignImpl extends BaseAbstract implements FallbackFactory<AvailableListFeign> {
    @Override
    public AvailableListFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new AvailableListFeign() {

            @PostMapping("/m/availableList/reFresh/cus")
            @Override
            public Result<Object> reFreshCus(ArrayList<String> cusCodes) {
                return doBack();
            }

            @Override
            public Result<PageResult<CusAvailablelistVo>> list(CusAvailablelistVo cusAvailablelistVo) {
                return doBack();
            }

            @Override
            public Result<Object> delById(String fictitiousId) {
                return doBack();
            }

            @Override
            public Result<Map<String, CusAvailablelistVo>> findGoodsByCusAndGoodsCodes(List<String> goodsCodes, String cusCode) {
                return doBack();
            }

            @GetMapping("/m/availableList/findById/{id}")
            @Override
            public Result<CusAvailablelistVo> findById(String id) {
                return doBack();
            }

            @Override
            public Result<Object> delByIds(List<String> ids) {
                return doBack();
            }
        };
    }
}
