package com.biz.crm.mdm.availablelistrule;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelistrule.impl.AvailableListRuleFeignImpl;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/16 11:41
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "availableListRuleFeign",name="crm-mdm",path = "mdm",fallbackFactory = AvailableListRuleFeignImpl.class)
public interface AvailableListRuleFeign {

    /**
     * 新增
     * @param availableListRuleVo
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/add")
    Result add(@RequestBody AvailableListRuleVo availableListRuleVo);

    /**
     * 新增（专属合同）
     *
     * @param availableListRuleVo 合同vo
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/addForConstract")
    Result addForConstract(@RequestBody AvailableListRuleVo availableListRuleVo);

    /**
     * 编辑
     * @param availableListRuleVo
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/edit")
    Result edit(@RequestBody AvailableListRuleVo availableListRuleVo);

    /**
     * 通过id查询
     * @param id
     * @return
     */
    @GetMapping(value = "/m/availableList/rule/findById/{id}")
    Result<AvailableListRuleVo> findById(@PathVariable("id") String id);

    /**
     * 通过来源单号查询
     * @param sourceId 合同编码
     * @return 查询结果
     */
    @GetMapping(value = "/m/availableList/rule/findBySourceId/{sourceId}")
    Result<AvailableListRuleVo> findBySourceId(@PathVariable("sourceId") String sourceId);

    /**
     * 分页搜索
     * @param availableListRuleVo
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/list")
    Result<PageResult<AvailableListRuleVo>> list(@RequestBody AvailableListRuleVo availableListRuleVo);

    /**
     * 根据id批量删除
     * @param ids
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/delByIds")
    Result<Object> delByIds(@RequestBody ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     * @param availableListRuleVo
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/delByParam")
    Result<Object> delByParam(@RequestBody AvailableListRuleVo availableListRuleVo);

    /**
     * 根据编码批量查询是否存在
     * @param codes
     * @return
     */
    @PostMapping(value = "/m/availableList/rule/findExistByCodes")
    Result<Map<String, Boolean>> findExistByCodes(@RequestBody List<String> codes);
}
