package com.biz.crm.mdm.bpmrole.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 流程角色表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-26 20:07:10
 */
@Slf4j
@Component
public class MdmBpmRoleFeignImpl extends BaseAbstract implements FallbackFactory<MdmBpmRoleFeign> {

    @Override
    public MdmBpmRoleFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmBpmRoleFeign() {

            @Override
            public Result<PageResult<MdmBpmRoleRespVo>> pageList(MdmBpmRoleReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<MdmBpmRoleRespVo> detail(String id, String bpmRoleCode) {
                return doBack();
            }

            @Override
            public Result save(MdmBpmRoleReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result update(MdmBpmRoleReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }

            @Override
            public Result enable(List<String> ids) {
                return doBack();
            }

            @Override
            public Result disable(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<Set<String>> findBpmRoleCodeSetByPositionCodeList(List<String> positionCodeList) {
                return doBack();
            }

        };
    }
}
