package com.biz.crm.mdm.columnconfig.impl;

import com.biz.crm.mdm.columnconfig.MdmColumnConfigFeign;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 字段配置feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-21 12:19:06
 */
@Slf4j
@Component
public class MdmColumnConfigFeignImpl extends BaseAbstract implements FallbackFactory<MdmColumnConfigFeign> {

    @Override
    public MdmColumnConfigFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmColumnConfigFeign() {

            @Override
            public Result<List<MdmColumnExportRespVo>> columnSelect(MdmColumnConfigReqVo mdmColumnConfigReqVo) {
                return doBack();
            }
        };
    }
}
