package com.biz.crm.mdm.cusorg.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.cusorg.MdmCustomerOrgRedisFeign;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgRedisVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgReloadRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 客户组织表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Component
public class MdmCustomerOrgRedisFeignImpl extends BaseAbstract implements FallbackFactory<MdmCustomerOrgRedisFeign> {

    @Override
    public MdmCustomerOrgRedisFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmCustomerOrgRedisFeign() {

            @Override
            public Result<List<MdmCustomerOrgRedisVo>> findRedisListByCustomerOrgCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmCustomerOrgParentChildrenRedisVo>> findRedisCustomerOrgParentListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmCustomerOrgParentChildrenRedisVo>> findRedisCustomerOrgChildrenListByCodeList(List<String> orgCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmCustomerOrgReloadRedisVo>> findRedisReloadList() {
                return doBack();
            }

        };
    }
}
