package com.biz.crm.mdm.customer;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.customer.impl.MdmCustomerTerminalFeignImpl;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerTerminalFeign",name="crm-mdm",path = "mdm",fallback = MdmCustomerTerminalFeignImpl.class)
public interface MdmCustomerTerminalFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmcustomerterminal/list")
    Result<PageResult<MdmCustomerTerminalRespVo>> list(@RequestBody MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);

    /**
     * 新增客户终端关联
     */
    @PostMapping("/mdmcustomerterminal/add")
    Result<Object> correlatedTerminal(@RequestBody MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo);

    /**
     * 客户终端查询
     */
    @PostMapping("/mdmcustomerterminal/page")
    Result<PageResult<MdmCustomerTerminalRespVo>> customerTerminalPage(@RequestBody MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo);


    @PostMapping("/mdmcustomerterminal/unbind")
    Result<Object> unbind(@RequestBody MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo);

    @PostMapping("/mdmcustomerterminal/replace")
    Result<Object> replaceCustomer(@RequestBody MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo);

    /**
     * 模糊查询客户信息或者终端信息
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmcustomerterminal/findCustomerTerminalFuzzyList")
    Result<List<MdmCustomerTerminalFuzzyQueryVo>> findCustomerTerminalFuzzyList(@RequestBody MdmCustomerTerminalFuzzyQueryVo reqVo);
}
