package com.biz.crm.mdm.feign;

import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(url = "${feign.urlip:}", qualifier = "mdmDictFeign", value = "crm-mdm", path = "mdm", fallbackFactory = MdmDictFeign.FallBackClass.class)
public interface MdmDictFeign {

    @PostMapping("/mdmdicttype/getDictGroupRedisList")
    Result<List<DictGroupRedisVo>> getDictGroupRedisList(@RequestBody List<String> dictTypeCodeList);

    @Component
    @Slf4j
    class FallBackClass implements FallbackFactory<MdmDictFeign> {
        @Override
        public MdmDictFeign create(Throwable throwable) {
            return new MdmDictFeign() {

                @Override
                public Result<List<DictGroupRedisVo>> getDictGroupRedisList(List<String> dictTypeCodeList) {
                    Result<List<DictGroupRedisVo>> result = new Result<>();
                    result.error500("请求失败");
                    return result;
                }

            };
        }
    }

}
