package com.biz.crm.mdm.material;


import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.material.impl.MdmMaterialFeignImpl;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MaterialMdmPaginationDto;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Component(value = "mdmMaterialFeign")
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmMaterialFeign", name = "crm-mdm", path = "mdm", fallback = MdmMaterialFeignImpl.class)
public interface MdmMaterialFeign {

  /**
   * 根据物料id或者物料编码查询物料详情
   */
  @GetMapping("/mdmMaterialController/detail")
  Result<MdmMaterialRespVo> detail(@RequestParam("id") String id, @RequestParam("materialCode") String materialCode);

  /**
   * 查询物料
   *
   * @param mdmMaterialOrgSearchReqVo
   * @return
   */
  @PostMapping("/mdmMaterialController/findCurrentAndSubMaterialList")
  Result<List<MdmMaterialPriceRespVo>> findCurrentAndSubMaterialList(@RequestBody MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo);


  /**
   * cps分页查询列表
   *
   * @param paginationDto
   * @return
   */
  @PostMapping("/mdmMaterialController/pageCpsList")
  Result<PageResult<MdmMaterialRespVo>> pageCpsList(@RequestBody MaterialMdmPaginationDto paginationDto);

  /**
   * 分页查询物料组信息
   *
   * @param groupReqVo
   * @return
   */
  @PostMapping("/mdmMaterialGroupController/pageList")
  Result<PageResult<MdmMaterialGroupRespVo>> pageList(@RequestBody MdmMaterialGroupReqVo groupReqVo);

  /**
   * cps分页查询物料组信息
   *
   * @param groupReqVo
   * @return
   */
  @PostMapping("/mdmMaterialGroupController/pageGroupCpsList")
  Result<PageResult<MdmMaterialGroupRespVo>> pageGroupCpsList(@RequestBody MdmMaterialGroupReqVo groupReqVo);

}
