package com.biz.crm.mdm.material.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MaterialMdmPaginationDto;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupReqVo;
import com.biz.crm.nebular.mdm.materialGroup.MdmMaterialGroupRespVo;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * feign接口熔断类
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@Slf4j
@Component
public class MdmMaterialFeignImpl extends BaseAbstract implements MdmMaterialFeign {

  @Override
  public Result<MdmMaterialRespVo> detail(String id, String materialCode) {
    return doBack();
  }

  /**
   * 查询物料
   *
   * @param mdmMaterialOrgSearchReqVo
   * @return
   */
  @Override
  public Result<List<MdmMaterialPriceRespVo>> findCurrentAndSubMaterialList(MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
    return doBack();
  }

  @Override
  public Result<PageResult<MdmMaterialRespVo>> pageCpsList(MaterialMdmPaginationDto paginationDto) {
    return doBack();
  }

  @Override
  public Result<PageResult<MdmMaterialGroupRespVo>> pageList(MdmMaterialGroupReqVo groupReqVo) {
    return doBack();
  }

  @Override
  public Result<PageResult<MdmMaterialGroupRespVo>> pageGroupCpsList(MdmMaterialGroupReqVo groupReqVo) {
    return doBack();
  }

}
