package com.biz.crm.mdm.mdmbuglistmanagement.impl;

import com.biz.crm.mdm.mdmbuglistmanagement.MdmBugListManagementFeign;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * bug管理主表feign接口熔断类
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */
@Slf4j
@Component
public class MdmBugListManagementFeignImpl extends BaseAbstract implements FallbackFactory<MdmBugListManagementFeign> {

    @Override
    public MdmBugListManagementFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmBugListManagementFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmBugListManagementRespVo>> list(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                doBack();
                PageResult<MdmBugListManagementRespVo> build = PageResult.<MdmBugListManagementRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmBugListManagementRespVo> query(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmBugListManagementReqVo mdmBugListManagementReqVo) {
                return doBack();
            }
        };
    }
}
