package com.biz.crm.mdm.newhope.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.newhope.NewHopeUserSyncFeign;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author maoshen
 * @date 2021/6/11.
 */
@Component
@Slf4j
public class NewHopeUserSyncFeignImpl extends BaseAbstract implements FallbackFactory<NewHopeUserSyncFeign> {
    @Override
    public NewHopeUserSyncFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new NewHopeUserSyncFeign() {
            @Override
            public Result userSyncAll(NewHopeReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result userSyncIncrement(NewHopeReqVo reqVo) {
                return doBack();
            }
        };
    }
}
