package com.biz.crm.mdm.permission;


import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.permission.impl.MdmPermissionFeignImpl;
import com.biz.crm.nebular.mdm.permission.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPermissionFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPermissionFeignImpl.class)
public interface MdmPermissionFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmpermission/list")
    Result<PageResult<MdmPermissionRespVo>> list(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmpermission/query")
    Result<MdmPermissionRespVo> query(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmpermission/save")
    Result save(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmpermission/update")
    Result update(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmpermission/delete")
    Result delete(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmpermission/enable")
    Result enable(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmpermission/disable")
    Result disable(@RequestBody  MdmPermissionReqVo mdmPermissionReqVo);

    @PostMapping("/mdmpermission/config_list")
    Result<List<MdmListConfigRespVo>> configList(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    @ApiOperation("菜单列表")
    @PostMapping("/mdmpermission/menu_list")
    Result<List<MdmPermissionMenuRespVo>> menuList(@RequestBody MdmPermissionModelReqVo mdmPermissionModelReqVo);

    @ApiOperation("权限对象范围列表")
    @PostMapping("/mdmpermission/obj_list")
    Result<List<MdmPermissionObjRespVo>> objList(@RequestBody MdmPermissionReqVo mdmPermissionReqVo);

    @ApiOperation("查询方式列表")
    @PostMapping("/mdmpermission/search_type_list")
    Result<List<MdmPermissionSearchTypeVo>> searchTypeList(@RequestBody MdmPermissionSearchTypeVo mdmPermissionSearchTypeVo);

    @ApiOperation("权限对象范围列表保存")
    @PostMapping("/mdmpermission/save_obj")
    Result<Object> saveObj(@RequestBody MdmPermissionObjReqVo mdmPermissionObjReqVo);

    @ApiOperation("菜单下拉框")
    @PostMapping("/mdmpermission/menu_select")
    Result<List<MdmPermissionSubModelRespVo>> menuSelect(@RequestBody MdmPermissionModelReqVo mdmPermissionModelReqVo);
}
