package com.biz.crm.mdm.position;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.position.impl.MdmPositionLevelFeignImpl;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 职位级别feign接口
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "MdmPositionLevelFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmPositionLevelFeignImpl.class)
public interface MdmPositionLevelFeign {

//    /**
//     * 列表
//     */
//    @PostMapping("/mdmpositionlevel/list")
//    Result<PageResult<MdmPositionLevelRespVo>> list(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 查询
//     */
//    @PostMapping("/mdmpositionlevel/query")
//    Result<MdmPositionLevelRespVo> query(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 新增
//     */
//    @PostMapping("/mdmpositionlevel/save")
//    Result save(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 更新
//     */
//    @PostMapping("/mdmpositionlevel/update")
//    Result update(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 删除
//     */
//    @PostMapping("/mdmpositionlevel/delete")
//    Result delete(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 启用
//     */
//    @PostMapping("/mdmpositionlevel/enable")
//    Result enable(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 禁用
//     */
//    @PostMapping("/mdmpositionlevel/disable")
//    Result disable(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
//
//    /**
//     * 查询职位级别下拉框选择数据
//     */
    @PostMapping("/mdmPositionLevelController/selectList")
    Result<List<MdmPositionLevelRespVo>> selectList(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo);
}
