package com.biz.crm.mdm.positioncustomerorg;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.positioncustomerorg.impl.MdmPositionCustomerOrgFeignImpl;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCustomerOrgUpdateReqVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.util.Result;

import java.util.List;

/**
 * 职位与用户关联表feign接口
 *
 * @author zxw
 * @date 2020-11-03 17:31:28
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPositionCustomerOrgFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPositionCustomerOrgFeignImpl.class)
public interface MdmPositionCustomerOrgFeign {

    /**
     * 列表
     */

    @ApiOperation("未关联职位分页")
    @PostMapping("/mdmpositioncustomerorg/un_relation_page")
    Result<PageResult<MdmPositionCustomerOrgRespVo>> unRelationPage(@RequestBody MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo);

    @ApiOperation("已关联职位列表")
    @PostMapping("/mdmpositioncustomerorg/relation_page")
    Result<List<MdmPositionCustomerOrgRespVo>> relationList(@RequestBody MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo);

    @ApiOperation("添加")
    @PostMapping("/mdmpositioncustomerorg/add")
    Result<Object> add(@RequestBody MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo);

    @ApiOperation("添加")
    @PostMapping("/mdmpositioncustomerorg/remove")
    Result<Object> remove(@RequestBody MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo);

}
