package com.biz.crm.mdm.priceconditiongroup.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupRelFieldReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.mdm.priceconditiongroup.MdmPriceConditionGroupRelFieldFeign;
import feign.hystrix.FallbackFactory;
import java.util.ArrayList;

/**
 * 条件字段分类和字段的关系表 feign接口熔断类
 *
 * @author huanglong
 * @date 2020-10-14 17:21:40
 */
@Slf4j
@Component
public class MdmPriceConditionGroupRelFieldFeignImpl extends BaseAbstract implements FallbackFactory<MdmPriceConditionGroupRelFieldFeign> {

    @Override
    public MdmPriceConditionGroupRelFieldFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPriceConditionGroupRelFieldFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmPriceConditionGroupRelFieldRespVo>> list(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                doBack();
                PageResult<MdmPriceConditionGroupRelFieldRespVo> build = PageResult.<MdmPriceConditionGroupRelFieldRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmPriceConditionGroupRelFieldRespVo> query(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmPriceConditionGroupRelFieldReqVo mdmPriceConditionGroupRelFieldReqVo) {
                return doBack();
            }
        };
    }
}
