package com.biz.crm.mdm.product.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.nebular.mdm.product.req.MdmProductBySfaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductQueryReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.*;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * mdm_product 商品主数据feign接口熔断类
 *
 * @author huang.long
 * @date 2020-09-01 16:31:19
 */
@Slf4j
@Component
public class MdmProductFeignImpl extends BaseAbstract implements FallbackFactory<MdmProductFeign> {

    @Override
    public MdmProductFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmProductFeign() {
            @Override
            public Result<List<MdmProductRespVo>> listCondition(MdmProductReqVo mdmProductReqVo) {
                return doBack();
            }

            @Override
            public Result<Map<String, MdmProductAdviseAndPriceRespVo>> queryByProductCodeAndCus(MdmProductAdviseAndPriceReqVo mdmProductAdviseAndPriceReqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmProductRespVo>> pageList(MdmProductReqVo mdmProductReqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmProductBySfaRespVo>> findProductListSourceSfa(MdmProductBySfaReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductBaseDataRespVo>> findProductBaseSourceSfaTpmAct(List<String> productCodeList) {
                return doBack();
            }

            @GetMapping("/mdmProductController/detail")
            @Override
            public Result<MdmProductRespVo> detail(String id, String productCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductRespVo>> queryBatchByIds(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductRespVo>> queryBatchByProductCodeList(List<String> productCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductRespVo>> queryBatchByProductLevelCodeList(List<String> productLevelCodeList) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductQueryRespVo>> queryProductList(MdmProductQueryReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmProductMediaRespVo>> queryBatchProductPictureList(List<String> productCodeList) {
                return doBack();
            }

            @Override
            public Result delete(List<String> ids) {
                return doBack();
            }

            @Override
            public Result enable(List<String> ids) {
                return doBack();
            }

            @Override
            public Result disable(List<String> ids) {
                return doBack();
            }

            @Override
            public Result upShelf(List<String> ids) {
                return doBack();
            }

            @Override
            public Result downShelf(List<String> ids) {
                return doBack();
            }
        };
    }
}
