package com.biz.crm.mdm.productlevel;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.productlevel.impl.MdmProductLevelFeignImpl;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmProductLevelFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmProductLevelFeignImpl.class)
public interface MdmProductLevelFeign {


    /**
     * 根据产品层级id或者产品层级编码查询产品层级详情
     *
     * @param id               产品层级id
     * @param productLevelCode 产品层级编码
     * @return
     */
    @GetMapping("/mdmProductLevelController/detail")
    Result<MdmProductLevelRespVo> detail(@RequestParam("id") String id, @RequestParam("productLevelCode") String productLevelCode);

    /**
     * 根据产品层级编码查询该产品层级及全部下级层级的编码
     *
     * @param productLevelCode 产品层级编码
     * @return
     */
    @GetMapping("/mdmProductLevelController/getAllChildrenProductLevelCodeList")
    Result<List<String>> getAllChildrenProductLevelCodeList(@RequestParam("productLevelCode") String productLevelCode);

    /**
     * 重置产品层级树降维编码
     */
    @PostMapping("/mdmProductLevelController/resetRuleCode")
    Result resetRuleCode();

    /**
     *查询产品层级下拉框选择数据
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmProductLevelController/productLevelSelectList")
    Result<List<MdmProductLevelSelectRespVo>> productLevelSelectList(@RequestBody MdmProductLevelSelectReqVo reqVo);

    /**
     * 获取所有产品层级
     *
     * @return
     */
    @GetMapping("/mdmProductLevelController/getAllProductLevelList")
    Result<List<MdmProductLevelRespVo>> getAllProductLevelList();

    /**
     * 查询列表(分页)
     * @param mdmProductLevelReqVo
     * @return
     */
    @PostMapping("/mdmProductLevelController/pageList")
    Result<PageResult<MdmProductLevelRespVo>> pageList(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo);
}
