package com.biz.crm.mdm.role.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.role.MdmRoleFeign;
import com.biz.crm.nebular.mdm.role.req.MdmUserRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 角色管理熔断类
 *
 * @author liaohua
 * @date 2020/10/23 2:21 下午
 */
@Slf4j
@Component
public class MdmRoleFeignImpl extends BaseAbstract implements FallbackFactory<MdmRoleFeign> {

    @Override
    public MdmRoleFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmRoleFeign() {

            @Override
            public Result<List<String>> getRoleByPositionCode(String positionCode) {
                return doBack() ;
            }

            @Override
            public Result<List<String>> getRoleByUserName(String userName) {
                return doBack();
            }

            @Override
            public Result<List<MdmRoleRespVo>> obtainUserRoleList(MdmUserRoleReqVo mdmUserRoleReqVo) {
                return doBack();
            }
        };
    }
}
